import base64

import requests


BASE_URL = "https://api.demdex.com"


class AdobeApiClient(object):
    def __init__(self, client_id, secret, user, password):
        self.client_id = client_id
        self.secret = secret
        self.user = user
        self.password = password

    def get_token(self):
        url = "{}/oauth/token".format(BASE_URL)
        params = {
            "grant_type": "password",
            "username": self.user,
            "password": self.password
        }
        headers = {
            "Authorization": "Basic {}".format(base64.b64encode("{}:{}".format(self.client_id, self.secret)))
        }
        response = requests.post(url, params=params, headers=headers)
        response.raise_for_status()
        return response.json().get("access_token")

    def get_destination_mappings(self, destination_id):
        headers = {
            "Authorization": "Bearer {}".format(self.get_token())
        }
        url = "{}/v1/destinations/{}/mappings".format(BASE_URL, destination_id)
        response = requests.get(url, headers=headers)
        response.raise_for_status()
        return response.json()
