#include <crypta/dmp/adobe/bin/common/config_fields.h>
#include <crypta/dmp/adobe/bin/update_bindings/lib/update_bindings_job.h>

#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>

using namespace NCrypta;
using namespace NDmp::NAdobe;

namespace {
    TUpdateBindingsJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TUpdateBindingsJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();

        config.InputDir = yaml[PARSED_EXT_ID_BINDINGS_DIR].as<NYT::TYPath>();
        config.StateTable = yaml[EXT_ID_BINDINGS_TABLE].as<NYT::TYPath>();
        config.ErrorsDir = yaml[UPDATE_BINDINGS_ERRORS_DIR].as<NYT::TYPath>();

        config.ErrorsTtl = yaml[ERRORS_TTL_DAYS].as<time_t>();
        config.ShouldDropInput = yaml[SHOULD_DROP_INPUT].as<bool>();
        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TUpdateBindingsJob, ParseConfig>(argc, argv);
}
