#include "bindings_update_utils.h"

using namespace NCrypta::NDmp;
using namespace NAdobe;
using namespace NBindingsUpdateUtils;

TVector<TSegmentId> NBindingsUpdateUtils::AddSegments(TSegmentIds& stateSegments, const TSegmentIds& segmentsToAdd) {
    TVector<TSegmentId> alreadyInStateIds;
    for (const auto& id : segmentsToAdd) {
        const auto [iter, wasInserted] = stateSegments.insert(id);
        if (!wasInserted) {
            alreadyInStateIds.push_back(id);
        }
    }
    return alreadyInStateIds;
}

TVector<TSegmentId> NBindingsUpdateUtils::RemoveSegments(TSegmentIds& stateSegments, const TSegmentIds& segmentsToRemove) {
    TVector<TSegmentId> notFoundInStateIds;
    for (const auto& id : segmentsToRemove) {
        const auto iter = stateSegments.find(id);
        if (iter != stateSegments.end()) {
            stateSegments.erase(iter);
        } else {
            notFoundInStateIds.push_back(id);
        }
    }
    return notFoundInStateIds;
}
