#pragma once

#include <crypta/lib/native/log/log.h>

#include <mapreduce/yt/interface/fwd.h>
#include <util/generic/string.h>

namespace NCrypta::NDmp::NAdobe {
    class TUpdateBindingsJob {
    public:
        struct TConfig {
            TString YtProxy;
            TString YtPool;

            NYT::TYPath InputDir;
            NYT::TYPath StateTable;
            NYT::TYPath ErrorsDir;

            time_t ErrorsTtl;
            bool ShouldDropInput;
        };

        explicit TUpdateBindingsJob(const TConfig& config, NLog::TLogPtr log);

        int Do();

    private:
        const TConfig Config;
        NLog::TLogPtr Log;
    };
}
