#include "update_full_bindings_reducer.h"

#include <crypta/dmp/common/serializers/bindings_serializer.h>

using namespace NCrypta::NDmp::NAdobe;

void TUpdateFullBindingsReducer::Do(TReader* reader, TWriter* writer) {
    TBindings bindingsState;
    for (; reader->IsValid(); reader->Next()) {
        const auto& bindings = NIdBindingsSerializer::Deserialize(reader->GetRow());
        bindingsState.Id = bindings.Id;
        bindingsState.Timestamp = bindings.Timestamp;
        bindingsState.Segments.insert(bindings.Segments.begin(), bindings.Segments.end());
    }

    if (!bindingsState.Segments.empty()) {
        writer->AddRow(NIdBindingsSerializer::Serialize(bindingsState));
    }
}

REGISTER_REDUCER(TUpdateFullBindingsReducer);
