#pragma once

#include <crypta/dmp/adobe/bin/common/bindings_diff.h>
#include <crypta/dmp/common/data/bindings.h>

#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NDmp::NAdobe {
    class TUpdateIterBindingsReducer: public NYT::IReducer<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        enum class EOutputTables {
            BindingsState,
            Errors
        };
        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TUpdateIterBindingsReducer() = default;
        explicit TUpdateIterBindingsReducer(const TOutputIndexes& outputIndexes);

        void Do(TReader* reader, TWriter* writer) override;

        static const ui64 STATE_TABLE_INDEX = 0;
        static const ui64 DIFF_TABLE_INDEX = 1;

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        TOutputIndexes OutputIndexes;
    };
}
