from datetime import datetime

import dateutil.parser

from crypta.dmp.adobe.bin.common.python import bindings_filename


class BucketStatus(object):
    def __init__(self, errors, latency, with_unknown_destinations):
        self.errors = errors
        self.latency = latency
        self.with_unknown_destinations = with_unknown_destinations

    def __repr__(self):
        return str(self.__dict__)

    def __eq__(self, other):
        return self.__dict__ == other.__dict__


def get_now_datetime():
    return datetime.now(dateutil.tz.UTC)


def get_bucket_status(keys, destination_ids):
    ALLOWED_FILENAMES = [".verifyACL", "./verifyACL"]
    errors = []
    with_unknown_destinations = 0
    min_upload_time = datetime.max.replace(tzinfo=dateutil.tz.UTC)

    for key in keys:
        try:
            filename = key.name
            if filename in ALLOWED_FILENAMES:
                continue

            destination_id = bindings_filename.parse(filename).destination_id
            if destination_id not in destination_ids:
                with_unknown_destinations += 1
                continue
        except Exception as e:
            errors.append(str(e))
            continue

        upload_time = dateutil.parser.parse(key.last_modified)
        if upload_time < min_upload_time:
            min_upload_time = upload_time

    latency = max((get_now_datetime() - min_upload_time).total_seconds(), 0)
    return BucketStatus(errors, latency, with_unknown_destinations)
