from crypta.lib.python.spine.consts.yt_proxy import YtProxy


class Check(object):
    REGISTRY_TAG = "upload_to_audience_check"

    def __init__(self, path, juggler_host, juggler_service):
        self.path = path
        self.juggler_host = juggler_host
        self.juggler_service = juggler_service

    def __repr__(self):
        return "Check(path={path}, juggler_host={juggler_host}, juggler_service={juggler_service})".format(
            path=repr(self.path),
            juggler_host=repr(self.juggler_host),
            juggler_service=repr(self.juggler_service)
        )


def add(juggler_check_generator, path, login):
    service = "{}_upload_to_audience_errors".format(login)
    raw_host = "{}-raw".format(juggler_check_generator.default_config.host)
    juggler_check_generator.store(Check.REGISTRY_TAG, Check(path, raw_host, service))

    juggler_check_generator.any(service)\
        .add_yt_dependencies([YtProxy.hahn])\
        .set_child(raw_host)\
        .set_ttl(7200)
