#include "bindings_fields.h"
#include "bindings_id_fields.h"
#include "bindings_schema.h"

using namespace NCrypta;
using namespace NDmp;
using namespace NBindingsFields;
using namespace NBindingsIdFields;

namespace {
    NYT::TTableSchema GetUnsortedBindingsSchema(const TString& idField) {
        return NYT::TTableSchema().AddColumn(NYT::TColumnSchema().Name(idField).Type(NYT::VT_STRING, /*required*/ true))
                                  .AddColumn(NYT::TColumnSchema().Name(TIMESTAMP).Type(NYT::VT_UINT64, /*required*/ true))
                                  .AddColumn(SEGMENTS, NYT::VT_ANY)
                                  .Strict(true);
    }

    NYT::TTableSchema GetBindingsSchema(const TString& idField) {
        auto schema = GetUnsortedBindingsSchema(idField).UniqueKeys(true);
        schema.MutableColumns().at(0).SortOrder(NYT::SO_ASCENDING);
        return schema;
    }
}

NYT::TTableSchema NDmp::GetExtIdBindingsSchema() {
    return GetBindingsSchema(EXT_ID);
}

NYT::TTableSchema NDmp::GetIdBindingsSchema() {
    return GetBindingsSchema(ID);
}

NYT::TTableSchema NDmp::GetYandexuidBindingsSchema() {
    return GetBindingsSchema(YANDEXUID);
}

NYT::TTableSchema NDmp::GetUnsortedIdBindingsSchema() {
    return GetUnsortedBindingsSchema(ID);
}

