#include "meta_schema.h"
#include "segment_fields.h"

NYT::TTableSchema NCrypta::NDmp::GetMetaSchema() {
    return NYT::TTableSchema()
        .AddColumn(NYT::TColumnSchema().Name(NSegmentFields::ID).Type(NYT::VT_UINT64, /*required*/ true).SortOrder(NYT::SO_ASCENDING))
        .AddColumn(NSegmentFields::TITLE, NYT::VT_ANY)
        .AddColumn(NSegmentFields::HIERARCHY, NYT::VT_ANY)
        .AddColumn(NYT::TColumnSchema().Name(NSegmentFields::TARIFF).Type(NYT::VT_UINT64, /*required*/ true))
        .AddColumn(NSegmentFields::DESCRIPTION, NYT::VT_ANY)
        .AddColumn(NSegmentFields::ACL, NYT::VT_ANY)
        .AddColumn(NYT::TColumnSchema().Name(NSegmentFields::STATUS).Type(NYT::VT_STRING, /*required*/ true))
        .AddColumn(NYT::TColumnSchema().Name(NSegmentFields::TIMESTAMP).Type(NYT::VT_UINT64, /*required*/ true))
        .Strict(true)
        .UniqueKeys(true);
}
