import yt.yson as yson


EXT_ID = "ext_id"
ID = "id"
YANDEXUID = "yandexuid"


def get_schema(id_field, unique_keys):
    schema = [
        {"name": id_field, "type": "string", "required": True, "sort_order": "ascending"},
        {"name": "segments", "type": "any", "required": False},
        {"name": "timestamp", "type": "uint64", "required": True}
    ]
    schema = yson.YsonList(schema)
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = unique_keys
    return schema


def get_id_schema():
    return get_schema(ID, unique_keys=True)


def get_ext_id_schema():
    return get_schema(EXT_ID, unique_keys=True)


def get_not_unique_yandexuid_schema():
    return get_schema(YANDEXUID, unique_keys=False)


def get_yandexuid_schema():
    return get_schema(YANDEXUID, unique_keys=True)
