from ads.bsyeti.libs.events.proto import dmp_pb2
from google.protobuf import json_format
import yt.yson as yson

from crypta.lib.python.yt.test_helpers import (
    tables,
)


def get_schema():
    schema = [
        {"name": "value", "type": "string", "required": True},
    ]
    schema = yson.YsonList(schema)
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema


def row_transformer(row):
    proto = dmp_pb2.TDmpSegments()
    proto.ParseFromString(row["value"])
    row["value"] = json_format.MessageToDict(proto)
    return row


def on_read():
    return tables.OnRead(row_transformer=row_transformer)
