import yt.yson as yson

from crypta.dmp.common.data.python import segment_fields


def get_schema():
    schema = [
        {"name": segment_fields.ID, "type": "uint64", "required": True, "sort_order": "ascending"},
        {"name": segment_fields.TITLE, "type": "any"},
        {"name": segment_fields.HIERARCHY, "type": "any"},
        {"name": segment_fields.TARIFF, "type": "uint64", "required": True},
        {"name": segment_fields.DESCRIPTION, "type": "any"},
        {"name": segment_fields.ACL, "type": "any"},
        {"name": segment_fields.STATUS, "type": "string", "required": True},
        {"name": segment_fields.TIMESTAMP, "type": "uint64", "required": True}
    ]
    schema = yson.YsonList(schema)
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = True
    return schema


def get_schema_with_sizes():
    schema = get_schema()
    schema.append({"name": segment_fields.YANDEXUID_SIZE, "type": "uint64", "required": True})
    schema.append({"name": segment_fields.EXT_ID_SIZE, "type": "uint64", "required": True})
    return schema


def get_schema_internal():
    schema = get_schema_with_sizes()
    schema.append({"name": segment_fields.PARENT_KEYWORD, "type": "uint64", "required": True})
    schema.append({"name": segment_fields.PARENT_SEGMENT, "type": "uint64", "required": True})
    return schema
