#include "segment.h"
#include "segment_statuses.h"

using namespace NCrypta::NDmp;

TSegment::TSegment(
    TSegmentId id,
    NYT::TNode title,
    NYT::TNode hierarchy,
    ui64 tariff,
    NYT::TNode description,
    NYT::TNode acl,
    TString status,
    ui64 timestamp)
    : Id(id)
    , Title(std::move(title))
    , Hierarchy(std::move(hierarchy))
    , Tariff(tariff)
    , Description(std::move(description))
    , Acl(std::move(acl))
    , Status(std::move(status))
    , Timestamp(timestamp)
{
}

bool TSegment::IsEnabled() const {
    return Status == NSegmentStatuses::ENABLED;
}

bool TSegment::IsDisabled() const {
    return Status == NSegmentStatuses::DISABLED;
}

bool TSegment::IsDeleted() const {
    return Status == NSegmentStatuses::DELETED;
}

void TSegment::SetEnabled() {
    Status = NSegmentStatuses::ENABLED;
}

void TSegment::SetDisabled() {
    Status = NSegmentStatuses::DISABLED;
}

void TSegment::SetDeleted() {
    Status = NSegmentStatuses::DELETED;
}

bool NCrypta::NDmp::operator==(const TSegment& lhs, const TSegment& rhs) {
    return (lhs.Id == rhs.Id) &&
           (lhs.Title == rhs.Title) &&
           (lhs.Hierarchy == rhs.Hierarchy) &&
           (lhs.Tariff == rhs.Tariff) &&
           (lhs.Description == rhs.Description) &&
           (lhs.Acl == rhs.Acl) &&
           (lhs.Status == rhs.Status) &&
           (lhs.Timestamp == rhs.Timestamp);
}

bool NCrypta::NDmp::operator!=(const TSegment& lhs, const TSegment& rhs) {
    return !(lhs == rhs);
}
