#pragma once

#include "segment_id.h"

#include <mapreduce/yt/interface/node.h>
#include <util/generic/maybe.h>

namespace NCrypta::NDmp {
    class TSegment {
    public:
        TSegment(
            TSegmentId id,
            NYT::TNode title,
            NYT::TNode hierarchy,
            ui64 tariff,
            NYT::TNode description,
            NYT::TNode acl,
            TString status,
            ui64 timestamp
        );

        bool IsEnabled() const;
        bool IsDisabled() const;
        bool IsDeleted() const;

        void SetEnabled();
        void SetDisabled();
        void SetDeleted();

        TSegmentId Id = 0;
        NYT::TNode Title;
        NYT::TNode Hierarchy;
        ui64 Tariff = 0;
        NYT::TNode Description;
        NYT::TNode Acl;
        TString Status;
        ui64 Timestamp = 0;
    };

    bool operator==(const TSegment& lhs, const TSegment& rhs);
    bool operator!=(const TSegment& lhs, const TSegment& rhs);
}
