#include "meta.h"

#include <crypta/dmp/common/serializers/segment_serializer.h>

using namespace NCrypta::NDmp;

THashSet<TSegmentId> NCrypta::NDmp::GetSegmentsIds(NYT::IClientBasePtr client, const NYT::TYPath& meta, std::function<bool(const TSegment&)> filter) {
    THashSet<TSegmentId> segmentsIds;
    auto reader = client->CreateTableReader<NYT::TNode>(meta);
    for (; reader->IsValid(); reader->Next()) {
        const auto segment = NSegmentSerializer::Deserialize(reader->GetRow());
        if (filter(segment)) {
            segmentsIds.insert(segment.Id);
        }
    }
    return segmentsIds;
}
