import logging

import yt.wrapper as yt

from crypta.lib.python.yql import executer


logger = logging.getLogger(__name__)

# TODO(kolontaev): Return after YQL-6896
# QUERY_TEMPLATE = """
# PRAGMA SimpleColumns;

# INSERT INTO [{yandexuid_bindings_table}] WITH TRUNCATE
# SELECT
#     ext_id_bindings.*,
#     cookies_matches.{cm_yandexuid_field} as {bindings_yandexuid_field}
#     WITHOUT ext_id_bindings.{bindings_ext_id_field}
# FROM [{ext_id_bindings_table}] as ext_id_bindings
# INNER JOIN [{cm_table}] as cookies_matches
# ON ext_id_bindings.{bindings_ext_id_field} = cookies_matches.{cm_ext_id_field};
# """

QUERY_TEMPLATE = """
INSERT INTO `{yandexuid_bindings_table}` WITH TRUNCATE
SELECT
     CAST(cookies_matches.{cm_yandexuid_field} AS String) as {bindings_yandexuid_field},
     ext_id_bindings.segments as segments,
     ext_id_bindings.`timestamp` as `timestamp`
FROM `{ext_id_bindings_table}` as ext_id_bindings
INNER JOIN `{cm_table}` as cookies_matches
ON ext_id_bindings.{bindings_ext_id_field} = CAST(cookies_matches.{cm_ext_id_field} AS String);
"""


def run(yt_proxy,
        yt_pool,
        yt_tmp_dir,
        ext_id_bindings_table,
        bindings_ext_id_field,
        cm_table,
        cm_ext_id_field,
        cm_yandexuid_field,
        yandexuid_bindings_table,
        bindings_yandexuid_field,
        yandexuid_bindings_table_schema):

    yt.config.set_proxy(yt_proxy)
    yt.config["pool"] = yt_pool

    yql_executer = executer.get_executer(yt_proxy, yt_pool, yt_tmp_dir)

    with yt.Transaction() as tx, yt.TempTable(yt_tmp_dir) as yql_query_dst_table:
        query = QUERY_TEMPLATE.format(ext_id_bindings_table=ext_id_bindings_table,
                                      bindings_ext_id_field=bindings_ext_id_field,
                                      cm_table=cm_table,
                                      cm_ext_id_field=cm_ext_id_field,
                                      cm_yandexuid_field=cm_yandexuid_field,
                                      yandexuid_bindings_table=yql_query_dst_table,
                                      bindings_yandexuid_field=bindings_yandexuid_field)

        logger.info("Running YQL query:\n%s", query)
        yql_executer(query, transaction=tx.transaction_id, syntax_version=1)

        destination_table = yt.TablePath(yandexuid_bindings_table, schema=yandexuid_bindings_table_schema, attributes={"optimize_for": "scan"})
        yt.create("map_node", yt.ypath_dirname(destination_table), recursive=True, ignore_existing=True)
        yt.run_sort(yql_query_dst_table, destination_table, sort_by=bindings_yandexuid_field)

    logger.info("Completed successfully")
