#include "merge_yandexuid_bindings_reducer.h"

#include <crypta/dmp/common/serializers/bindings_serializer.h>

using namespace NCrypta::NDmp;

void TMergeYandexuidBindingsReducer::Do(TReader* reader, TWriter* writer) {
    TBindings res;

    for (; reader->IsValid(); reader->Next()) {
        const auto& bindings = NYandexuidBindingsSerializer::Deserialize(reader->GetRow());
        res.Id = bindings.Id;
        res.Timestamp = Max(bindings.Timestamp, res.Timestamp);
        res.Segments.insert(bindings.Segments.begin(), bindings.Segments.end());
    }

    writer->AddRow(NYandexuidBindingsSerializer::Serialize(res));
}

REGISTER_REDUCER(TMergeYandexuidBindingsReducer);
