#include "bb_upload_state_serializer.h"

#include <crypta/dmp/common/data/bb_upload_state_fields.h>
#include <crypta/dmp/common/serializers/bindings_serializer.h>

using namespace NCrypta::NDmp;
using namespace NBbUploadStateFields;

NYT::TNode NBbUploadStateSerializer::Serialize(const TBbUploadState& bbUploadState) {
    auto node = NYandexuidBindingsSerializer::Serialize(bbUploadState.Bindings);
    node[UPLOAD_TIMESTAMP] = bbUploadState.LastUploadTimestamp;
    return node;
}

TBbUploadState NBbUploadStateSerializer::Deserialize(const NYT::TNode& node) {
    const auto bindings = NYandexuidBindingsSerializer::Deserialize(node);
    const ui64 lastUploadTimestamp = node.At(UPLOAD_TIMESTAMP).As<ui64>();
    return TBbUploadState(std::move(bindings), lastUploadTimestamp);
}
