#include "bindings_serializer.h"

#include <crypta/dmp/common/data/bindings_fields.h>
#include <crypta/dmp/common/data/bindings_id_fields.h>

using namespace NCrypta::NDmp;
using namespace NBindingsFields;
using namespace NBindingsIdFields;

namespace {
    NYT::TNode Serialize(const TBindings& bindings, const TString& idField) {
        NYT::TNode node;
        node[idField] = bindings.Id;
        node[TIMESTAMP] = bindings.Timestamp;
        node[SEGMENTS] = NYT::TNode::CreateList();
        for (const auto& segment : bindings.Segments) {
            node[SEGMENTS].Add(segment);
        }
        return node;
    }

    TBindings Deserialize(const NYT::TNode& node, const TString& idField) {
        TString id = node.At(idField).AsString();
        const ui64 timestamp = node.At(TIMESTAMP).AsUint64();
        TSegmentIds segments;
        for (const auto& segment : node.At(SEGMENTS).AsList()) {
            segments.insert(segment.AsUint64());
        }
        return TBindings(std::move(id), timestamp, std::move(segments));
    }
}

NYT::TNode NExtIdBindingsSerializer::Serialize(const TBindings& bindings) {
    return ::Serialize(bindings, EXT_ID);
}

TBindings NExtIdBindingsSerializer::Deserialize(const NYT::TNode& node) {
    return ::Deserialize(node, EXT_ID);
}

NYT::TNode NIdBindingsSerializer::Serialize(const TBindings& bindings) {
    return ::Serialize(bindings, ID);
}

TBindings NIdBindingsSerializer::Deserialize(const NYT::TNode& node) {
    return ::Deserialize(node, ID);
}

NYT::TNode NYandexuidBindingsSerializer::Serialize(const TBindings& bindings) {
    return ::Serialize(bindings, YANDEXUID);
}

TBindings NYandexuidBindingsSerializer::Deserialize(const NYT::TNode& node) {
    return ::Deserialize(node, YANDEXUID);
}
