#include "dmp_segments_proto_log_serializer.h"

#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <ads/bsyeti/libs/events/proto/dmp.pb.h>

#include <util/string/join.h>

using namespace NCrypta::NDmp;

TString NDmpSegmentsProtoLogSerializer::Serialize(const TBindings& bindings, ui64 dmpId) {
    NBSYeti::NEvent::TDmpSegments dmpSegments;
    dmpSegments.set_dmp_id(dmpId);
    dmpSegments.set_yandexuid(FromString<ui64>(bindings.Id));
    dmpSegments.set_unixtime(bindings.Timestamp);
    *dmpSegments.mutable_uint_segments() = {bindings.Segments.begin(), bindings.Segments.end()};

    return NProtoSerializer::ToString(dmpSegments);
}
