#include "segment_serializer.h"

#include <crypta/dmp/common/data/segment_fields.h>

using namespace NCrypta::NDmp;

NYT::TNode NSegmentSerializer::Serialize(const TSegment& segment) {
    NYT::TNode node;
    node[NSegmentFields::ID] = segment.Id;
    node[NSegmentFields::TITLE] = segment.Title;
    node[NSegmentFields::HIERARCHY] = segment.Hierarchy;
    node[NSegmentFields::TARIFF] = segment.Tariff;
    node[NSegmentFields::DESCRIPTION] = segment.Description;
    node[NSegmentFields::ACL] = segment.Acl;
    node[NSegmentFields::STATUS] = segment.Status;
    node[NSegmentFields::TIMESTAMP] = segment.Timestamp;
    return node;
}

TSegment NSegmentSerializer::Deserialize(const NYT::TNode& node) {
    return TSegment(
        node.At(NSegmentFields::ID).AsUint64(),
        node.At(NSegmentFields::TITLE),
        node.At(NSegmentFields::HIERARCHY),
        node.At(NSegmentFields::TARIFF).AsUint64(),
        node.At(NSegmentFields::DESCRIPTION),
        node.At(NSegmentFields::ACL),
        node.At(NSegmentFields::STATUS).AsString(),
        node.At(NSegmentFields::TIMESTAMP).AsUint64());
}
