import re


class AudienceSegmentName(object):
    def __init__(self, aam_segment_id, title):
        self.aam_segment_id = aam_segment_id
        self.title = title

    def __str__(self):
        return str(self.__dict__)

    __repr__ = __str__


def serialize(segment_name):
    return "{} [{}]".format(segment_name.title, segment_name.aam_segment_id)


def deserialize(raw_segment_name):
    parsed_data = re.search(r"^(.*) \[([0-9]+)\]$", raw_segment_name)
    if parsed_data is None:
        raise Exception("Can't parse raw segment name: {}".format(raw_segment_name))

    return AudienceSegmentName(int(parsed_data.group(2)), parsed_data.group(1))


def get_raw_audience_segment_name(aam_segment_id, title):
    return serialize(AudienceSegmentName(aam_segment_id, title))
