#include "builder.h"

#include <ads/bsyeti/libs/vinyl/burn.h>
#include <util/stream/file.h>

namespace NCrypta::NDmp::NKeywordsMapping {
    TBaseEditor CreateBaseEditor(ui64 dmpId) {
        TBaseEditor base;
        base.DmpId = dmpId;
        return base;
    };

    void AddSegment(TBaseEditor& baseEditor, ui64 dmpSegmentId, ui64 parentKeyword, ui64 parentSegment) {
        baseEditor.Keywords[parentKeyword][parentSegment] = dmpSegmentId;
    };

    void SaveToFile(const TBaseEditor& baseEditor, const TString& filename) {
        TFileOutput out(filename);
        NVinyl::Burn(out, baseEditor, "Segments mapping to Crypta DMP", TBaseEditor::BASE_VERSION);
        out.Flush();
    }
}
