import logging
import tempfile

from crypta.dmp.crypta.services.build_dmp_mapping.bin import builder
from crypta.dmp.crypta.services.build_dmp_mapping.proto import config_pb2
from crypta.lib.python import getoptpb
import crypta.lib.python.bt.conf.conf as conf
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.sandbox.client import SandboxClient
from crypta.lib.python.yt import yt_helpers

logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    conf.use_proto(getoptpb.ParsePbOptions(config_pb2.TConfig))

    yt_client = yt_helpers.get_yt_client(conf.proto.Yt.Proxy)

    rows = yt_client.read_table(conf.proto.DmpMetaPath)

    sandbox_client = SandboxClient(conf.proto.Sandbox.Token)

    with tempfile.NamedTemporaryFile("w") as output:
        builder.build(conf.proto.DmpId, rows, output.name)

        resource_id = sandbox_client.upload_to_sandbox(
            path=output.name,
            resource_type="CRYPTA_DMP_KEYWORD_TO_CRYPTA_DMP_MAPPING",
            description="Mapping of Bigb keywords to Crypta DMP segments",
            owner="CRYPTA",
            attributes={"ttl": "inf", "released": "stable"},
            alias_path="keyword_to_dmp_mapping_v1.vinyl",
        )
        logger.info("Uploaded keyword mapping, id: %s", resource_id)
