#include "fresh_segments.h"

#include <mapreduce/yt/util/ypath_join.h>
#include <util/string/builder.h>

using namespace NCrypta::NDmp;

TVector<TFreshSegments> TFreshSegments::List(
    NYT::IClientBasePtr client,
    const NYT::TYPath& root,
    std::function<ui64(const TString&)> GetTimestampFromDirname)
{
    TVector<TFreshSegments> listOfFreshSegments;

    for (const auto& dirName : client->List(root)) {
        const ui64 timestamp = GetTimestampFromDirname(dirName.AsString());
        const NYT::TYPath dir = NYT::JoinYPaths(root, dirName.AsString());
        const NYT::TYPath meta = NYT::JoinYPaths(dir, "meta");
        const NYT::TYPath bindings = NYT::JoinYPaths(dir, "bindings");
        Y_ENSURE(client->Exists(meta));
        listOfFreshSegments.push_back(TFreshSegments(timestamp, dir, meta, client->Exists(bindings) ? MakeMaybe(bindings) : Nothing()));
    }

    return listOfFreshSegments;
}

void TFreshSegments::Remove(NYT::ITransactionPtr tx) const {
    const auto removeOptions = NYT::TRemoveOptions().Recursive(false);
    tx->Remove(Meta, removeOptions);
    if (Bindings.Defined()) {
        tx->Remove(Bindings.GetRef(), removeOptions);
    }
    tx->Remove(Dir, removeOptions);
}

TFreshSegments::TFreshSegments(ui64 timestamp, const NYT::TYPath& dir, const NYT::TYPath& meta, const TMaybe<NYT::TYPath>& bindings)
    : Timestamp(timestamp)
    , Dir(dir)
    , Meta(meta)
    , Bindings(bindings)
{
}

TString NCrypta::NDmp::ToString(const TFreshSegments& freshSegments) {
    return TStringBuilder() << "TFreshSegments{Meta=" << freshSegments.Meta << "; Bindings=" << freshSegments.Bindings << "}";
}
