#pragma once

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NDmp {
    class TFreshSegments {
    public:
        static TVector<TFreshSegments> List(
            NYT::IClientBasePtr client,
            const NYT::TYPath& root,
            std::function<ui64(const TString&)> GetTimestampFromDirname);

        void Remove(NYT::ITransactionPtr tx) const;

        const ui64 Timestamp;
        const NYT::TYPath Dir;
        const NYT::TYPath Meta;
        const TMaybe<NYT::TYPath> Bindings;

    private:
        TFreshSegments(ui64 timestamp, const NYT::TYPath& dir, const NYT::TYPath& meta, const TMaybe<NYT::TYPath>& bindings);
    };

    TString ToString(const TFreshSegments& freshSegments);
}
