#include "error_fields.h"
#include "helpers.h"

#include <mapreduce/yt/util/ypath_join.h>
#include <util/generic/hash_set.h>
#include <util/string/builder.h>

using namespace NCrypta::NDmp;

NYT::TNode NCrypta::NDmp::CreateError(const TString& source, const NYT::TNode& value, const NYT::TNode& msg) {
    Y_ENSURE(msg.IsList() || msg.IsString());
    Y_ENSURE(!msg.Empty());
    NYT::TNode node;
    node[NErrorFields::SOURCE] = source;
    node[NErrorFields::VALUE] = value;
    node[NErrorFields::MESSAGES] = msg.IsList() ? msg : NYT::TNode().Add(msg);
    return node;
}

TString NCrypta::NDmp::GetArchiveName(ui64 timestamp) {
    return TStringBuilder() << "segments-" << timestamp << ".tar.gz";
}

void NCrypta::NDmp::MoveToQuarantine(NYT::ITransactionPtr tx, const NYT::TYPath& errors, const NYT::TYPath& quarantineDir, ui64 timestamp) {
    const TString destination = NYT::JoinYPaths(quarantineDir, GetArchiveName(timestamp), "errors");
    tx->Copy(errors, destination, NYT::TCopyOptions().Recursive(true));
}
