#include "segment_node_differ.h"

#include <crypta/dmp/common/data/segment_fields.h>
#include <crypta/dmp/common/serializers/segment_serializer.h>

using namespace NCrypta::NDmp;
using namespace NSegmentFields;

NYT::TNode NCrypta::NDmp::DiffSegments(const TSegment& from, const TSegment& to) {
    const auto fromNode = NSegmentSerializer::Serialize(from);
    const auto toNode = NSegmentSerializer::Serialize(to);
    auto diff = NYT::TNode::CreateMap();
    for (const auto& field : {ID, TITLE, HIERARCHY, TARIFF, DESCRIPTION, ACL, STATUS}) {
        if (fromNode.At(field) != toNode.At(field)) {
            diff[field] = NYT::TNode()("from", fromNode.At(field))("to", toNode.At(field));
        }
    }
    return diff;
}
