import argparse
import logging

from crypta.dmp.yandex.bin.make_mac_hash_yuid.lib import mac_hash_yuid_maker
from crypta.dmp.yandex.bin.make_mac_hash_yuid.lib.config_pb2 import TConfig
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets


def parse_args():
    parser = argparse.ArgumentParser(description="Make mac hash -- yuid table")
    parser.add_argument("--config", required=True, type=lambda x: yaml_config.parse_config(TConfig, x))
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger = logging.getLogger(__name__)

    args = parse_args()
    logger.info("Config:\n%s", proto_secrets.get_copy_without_secrets(args.config))

    mac_hash_yuid_maker.make(args.config, logger)

    logger.info("Completed successfully")
