from crypta.dmp.yandex.bin.make_mac_hash_yuid.lib import mac_hash_yuid_schema
from crypta.dmp.yandex.bin.make_mac_hash_yuid.lib.mac_md5_mapper import MacMD5Mapper
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers


def make(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    def tmp_table():
        return yt_client.TempTable(config.Yt.TmpDir)

    with yt_client.Transaction() as tx, tmp_table() as vmetro_mac_hash_yuid_table, tmp_table() as actual_indevice_mac_yuid_table, tmp_table() as indevice_mac_hash_yuid_table:
        filter_actual_indevice_mac_yuid(config.Yt, tx, config.IndeviceMacYuidTable, config.ActualYuidTable, actual_indevice_mac_yuid_table, logger)
        yt_client.run_map(MacMD5Mapper("mac", ["yuid"]), actual_indevice_mac_yuid_table, indevice_mac_hash_yuid_table)
        yt_client.run_map(MacMD5Mapper("id_value", ["yuid"]), config.VmetroMacYuidTable, vmetro_mac_hash_yuid_table)
        yt_client.remove(config.OutputMacHashYuidTable, force=True)
        yt_client.create("table", config.OutputMacHashYuidTable, recursive=True, attributes={"schema": mac_hash_yuid_schema.get(), "optimize_for": "scan"})
        concatenate_mac_hash_yuid(config.Yt, tx, indevice_mac_hash_yuid_table, vmetro_mac_hash_yuid_table, config.OutputMacHashYuidTable, logger)


def filter_actual_indevice_mac_yuid(yt_config, tx, indevice_mac_yuid_table, actual_yuid_table, actual_indevice_mac_yuid_table, logger):
    params = {
        "indevice_mac_yuid_table": indevice_mac_yuid_table,
        "actual_yuid_table": actual_yuid_table,
        "actual_indevice_mac_yuid_table": actual_indevice_mac_yuid_table,
    }
    yql_helpers.run_query("/query/filter_actual_indevice_mac_yuid.yql", yt_config, params, logger, tx=tx)


def concatenate_mac_hash_yuid(yt_config, tx, indevice_mac_hash_yuid_table, vmetro_mac_hash_yuid_table, output_mac_hash_yuid_table, logger):
    params = {
        "indevice_mac_hash_yuid_table": indevice_mac_hash_yuid_table,
        "vmetro_mac_hash_yuid_table": vmetro_mac_hash_yuid_table,
        "output_mac_hash_yuid_table": output_mac_hash_yuid_table,
    }
    yql_helpers.run_query("/query/concatenate_mac_hash_yuid.yql", yt_config, params, logger, tx=tx)
