import binascii
import hashlib
import logging

from crypta.lib.python.identifiers.identifiers import Mac


logger = logging.getLogger(__name__)


def get_mac_md5(mac):
    if not Mac(mac).is_valid():
        return None

    mac = Mac(mac).normalize.replace(':', '').upper().strip()
    if not mac:
        return None

    try:
        mac_bin = binascii.unhexlify(mac)
        return hashlib.md5(mac_bin).hexdigest().upper()
    except Exception:
        logger.warn("Wrong MAC format: %s", mac)
        return None
