import logging

from crypta.dmp.yandex.bin.make_mac_hash_yuid.lib import mac_md5

logger = logging.getLogger(__name__)


class MacMD5Mapper(object):
    def __init__(self, mac_field, other_fields):
        self.mac_field = mac_field
        self.other_fields = other_fields

    def __call__(self, row):
        mac_hash = mac_md5.get_mac_md5(row[self.mac_field])
        if mac_hash:
            result = {key: row[key] for key in self.other_fields}
            result["mac_hash"] = mac_hash
            yield result
