import argparse
import logging

from crypta.dmp.common import match_cookies
from crypta.dmp.common.data.python import bindings
from crypta.dmp.yandex.bin.common.python import config_fields
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Matches cookies")
    parser.add_argument("--config", help="Config file path", required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    config = args.config
    logger.info("Config: %s", config)

    match_cookies.run(yt_proxy=config[config_fields.YT_PROXY],
                      yt_pool=config[config_fields.YT_POOL],
                      yt_tmp_dir=config[config_fields.YT_TMP_DIR],
                      ext_id_bindings_table=config[config_fields.EXT_ID_BINDINGS_TABLE],
                      bindings_ext_id_field=bindings.EXT_ID,
                      cm_table=config[config_fields.COOKIE_MATCHING_TABLE],
                      cm_ext_id_field=config[config_fields.CM_EXT_ID_FIELD],
                      cm_yandexuid_field=config[config_fields.CM_YANDEXUID_FIELD],
                      yandexuid_bindings_table=config[config_fields.UNMERGED_YANDEXUID_BINDINGS_TABLE],
                      bindings_yandexuid_field=bindings.YANDEXUID,
                      yandexuid_bindings_table_schema=bindings.get_not_unique_yandexuid_schema())
