#include "merge_yandexuid_bindings_job.h"

#include <crypta/dmp/common/data/bindings_id_fields.h>
#include <crypta/dmp/common/data/bindings_schema.h>
#include <crypta/dmp/common/merge_yandexuid_bindings/merge_yandexuid_bindings_reducer.h>

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/client.h>

using namespace NCrypta;
using namespace NDmp;

TMergeYandexuidJob::TMergeYandexuidJob(const TConfig& config, NLog::TLogPtr log)
    : Config(config)
    , Log(log)
{
    Y_ENSURE(log != nullptr);
}

int TMergeYandexuidJob::Do() {
    Log->info("================ Start ================");
    Log->info("Input table is {}", Config.InputTable);
    Log->info("Output table is {}", Config.OutputTable);
    NYT::TConfig::Get()->Pool = Config.YtPool;
    auto client = NYT::CreateClient(Config.YtProxy);

    const auto outputTable = NYT::TRichYPath(Config.OutputTable).Schema(GetYandexuidBindingsSchema())
                                                                .OptimizeFor(NYT::OF_SCAN_ATTR);
    auto spec = NYT::TReduceOperationSpec().ReduceBy({NBindingsIdFields::YANDEXUID})
                                           .AddInput<NYT::TNode>(Config.InputTable)
                                           .AddOutput<NYT::TNode>(outputTable);

    client->Reduce(spec, new TMergeYandexuidBindingsReducer());
    Log->info("================ Finish ================");
    return 0;
}
