#include <crypta/dmp/yandex/bin/common/config_fields.h>
#include <crypta/dmp/yandex/bin/parse_segments/lib/parse_segments_job.h>

#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>

using namespace NCrypta;
using namespace NDmp;

namespace {
    TParseSegmentsJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TParseSegmentsJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();
        config.InputDir = yaml[RAW_SEGMENTS_DIR].as<NYT::TYPath>();
        config.OutputDir = yaml[PARSED_SEGMENTS_DIR].as<NYT::TYPath>();
        config.QuarantineDir = yaml[QUARANTINE_DIR].as<NYT::TYPath>();
        config.ShouldDropInput = yaml[SHOULD_DROP_INPUT].as<bool>();

        const auto& ownerLoginNode = yaml[OWNER_LOGIN];
        config.OwnerLogin = ownerLoginNode.IsDefined() ? MakeMaybe(ownerLoginNode.as<TString>()) : Nothing();

        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TParseSegmentsJob, ParseConfig>(argc, argv);
}
