#include "check_duplicate_bindings_reducer.h"

#include <crypta/dmp/common/data/bindings_id_fields.h>
#include <crypta/dmp/yandex/bin/common/helpers.h>

using namespace NCrypta::NDmp;

TCheckDuplicateBindingsReducer::TCheckDuplicateBindingsReducer(const TOutputIndexes& outputIndexes)
    : OutputIndexes(outputIndexes)
{
}

void TCheckDuplicateBindingsReducer::Do(TReader* reader, TWriter* writer) {
    const auto row = reader->GetRow();

    reader->Next();
    if (reader->IsValid()) {
        const auto& extId = row.AsMap().at(NBindingsIdFields::EXT_ID).AsString();
        const auto& error = CreateError("bindings", extId, "several entries for one user id found");
        writer->AddRow(error, OutputIndexes[EOutputTables::Errors].GetRef());
    } else {
        writer->AddRow(row, OutputIndexes[EOutputTables::Bindings].GetRef());
    }
}

REGISTER_REDUCER(TCheckDuplicateBindingsReducer);
