#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NDmp {
    class TCheckDuplicateBindingsReducer : public NYT::IReducer<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        enum class EOutputTables {
            Bindings,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TCheckDuplicateBindingsReducer() = default;
        TCheckDuplicateBindingsReducer(const TOutputIndexes& outputIndexes);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        TOutputIndexes OutputIndexes;
    };
}
