#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <mapreduce/yt/interface/client.h>
#include <util/generic/hash_set.h>

namespace NCrypta {
    namespace NDmp {
        class TParseBindingsMapper : public NYT::IMapper<NYT::TNodeReader, NYT::TNodeWriter> {
        public:
            enum class EOutputTables {
                Bindings,
                Errors
            };

            using TOutputIndexes = TTablesIndexes<EOutputTables>;

            TParseBindingsMapper() = default;
            TParseBindingsMapper(const TOutputIndexes& outputIndexes, ui64 timestamp, const THashSet<ui64>& segmentsIds);

            void Do(TReader* reader, TWriter* writer) override;

            Y_SAVELOAD_JOB(OutputIndexes, Timestamp, SegmentsIds);

        private:
            TOutputIndexes OutputIndexes;
            ui64 Timestamp;
            THashSet<ui64> SegmentsIds;
        };
    }
}
