#pragma once

#include <crypta/dmp/yandex/bin/common/fresh_segments.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/yt/utils/timed_suffix_generator.h>

#include <mapreduce/yt/util/temp_table.h>

namespace NCrypta::NDmp {
    class TParseSegmentsJob {
    public:
        struct TConfig {
            TString YtProxy;
            TString YtPool;
            NYT::TYPath InputDir;
            NYT::TYPath OutputDir;
            NYT::TYPath QuarantineDir;
            bool ShouldDropInput;
            TMaybe<TString> OwnerLogin;
        };

        TParseSegmentsJob(const TConfig& config, NLog::TLogPtr log);

        int Do();

    private:
        void ParseSegments(NYT::ITransactionPtr tx, const TFreshSegments& freshSegments);
        bool ParseMeta(NYT::ITransactionPtr tx, ui64 timestamp, const NYT::TYPath& input, const NYT::TYPath& output);
        bool ParseBindings(NYT::ITransactionPtr tx, ui64 timestamp, const NYT::TYPath& input, const NYT::TYPath& output, const THashSet<ui64>& segmentsIds);
        bool CheckDuplicateBindings(NYT::ITransactionPtr tx, const NYT::TYPath& bindings, ui64 timestamp) const;

        const TConfig Config;
        NLog::TLogPtr Log;
        TTimedSuffixGenerator TimedSuffixGenerator;
    };
}
