#include "raw_bindings_parser.h"

#include <library/cpp/deprecated/split/delim_string_iter.h>
#include <util/string/split.h>

using namespace NCrypta::NDmp;

TBindings NCrypta::NDmp::ParseRawBindings(const TString& raw, ui64 timestamp) {
    TStringBuf id;
    TStringBuf tail;
    Split(raw, '\t', id, tail);
    TSet<ui64> segments;
    if (!tail.empty()) {
        for (TDelimStringIter it(tail, ";"); it.Valid();) {
            segments.insert(it.GetNext<ui64>());
        }
    }
    return TBindings(TString(id), timestamp, std::move(segments));
}
