#include "raw_bindings_parser.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NDmp;

const static ui64 TIMESTAMP = 1500000000;

Y_UNIT_TEST_SUITE(RawBindingsParser) {
    Y_UNIT_TEST(Valid) {
        UNIT_ASSERT_EQUAL(ParseRawBindings("xxx\t", TIMESTAMP), TBindings("xxx", TIMESTAMP, {}));
        UNIT_ASSERT_EQUAL(ParseRawBindings("xxx\t1", TIMESTAMP), TBindings("xxx", TIMESTAMP, {1}));
        UNIT_ASSERT_EQUAL(ParseRawBindings("xxx\t1;4;7;11", TIMESTAMP), TBindings("xxx", TIMESTAMP, {1, 4, 7, 11}));
    }

    Y_UNIT_TEST(Invalid) {
        UNIT_ASSERT_EXCEPTION(ParseRawBindings("xxx\txxx", TIMESTAMP), TFromStringException);
        UNIT_ASSERT_EXCEPTION(ParseRawBindings("xxx\t1,4,7,11", TIMESTAMP), TFromStringException);
        UNIT_ASSERT_EXCEPTION(ParseRawBindings("xxx", TIMESTAMP), yexception);
        UNIT_ASSERT_EXCEPTION(ParseRawBindings("xxx\t1\t4", TIMESTAMP), yexception);
        UNIT_ASSERT_EXCEPTION(ParseRawBindings("xxx\t\t\t\t1;4;7;11", TIMESTAMP), yexception);
        UNIT_ASSERT_EXCEPTION(ParseRawBindings("", TIMESTAMP), yexception);
    }
}
