#include "raw_segment_parser.h"

#include "crypta/dmp/common/data/segment_fields.h"
#include "crypta/dmp/common/data/segment_statuses.h"


using namespace NCrypta::NDmp;

TSegment NCrypta::NDmp::ParseRawSegment(const NYT::TNode& raw, ui64 timestamp) {
    const ui64 id = raw.At(NSegmentFields::ID).ConvertTo<ui64>();
    const NYT::TNode& title = raw.At(NSegmentFields::TITLE);
    const NYT::TNode& hierarchy = raw.At(NSegmentFields::HIERARCHY);
    const ui64 tariff = raw.At(NSegmentFields::TARIFF).ConvertTo<ui64>();
    const NYT::TNode description = raw.HasKey(NSegmentFields::DESCRIPTION) ? raw.At(NSegmentFields::DESCRIPTION) : NYT::TNode::CreateEntity();
    const NYT::TNode acl = raw.HasKey(NSegmentFields::ACL) ? raw.At(NSegmentFields::ACL) : NYT::TNode::CreateEntity();
    return TSegment(id, title, hierarchy, tariff, description, acl, NSegmentStatuses::ENABLED, timestamp);
}
