#include "raw_segment_parser.h"

#include <crypta/dmp/common/data/segment_fields.h>
#include <crypta/dmp/common/data/segment_statuses.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NDmp;

const static ui64 TIMESTAMP = 1500000000;

Y_UNIT_TEST_SUITE(RawSegmentParser) {
    Y_UNIT_TEST(Optional) {
        const i64 Id = 1;
        const NYT::TNode Title = NYT::TNode()("en_US", "Soul");
        const NYT::TNode Hierarchy = NYT::TNode()("en_US", NYT::TNode().Add("Taxonomy XXX").Add("Auto").Add("Kia"));
        const i64 Tariff = 4;
        const NYT::TNode Description = NYT::TNode()("en_US", "Kia Soul");
        const NYT::TNode Acl = NYT::TNode().Add("xxx").Add("zzz");
        const TSegment segment(Id, Title, Hierarchy, Tariff, Description, Acl, NSegmentStatuses::ENABLED, TIMESTAMP);
        const NYT::TNode raw = NYT::TNode()
            (NSegmentFields::ID, Id)
            (NSegmentFields::TITLE, Title)
            (NSegmentFields::HIERARCHY, Hierarchy)
            (NSegmentFields::TARIFF, Tariff)
            (NSegmentFields::DESCRIPTION, Description)
            (NSegmentFields::ACL, Acl);
        UNIT_ASSERT_EQUAL(ParseRawSegment(raw, TIMESTAMP), segment);
    }

    Y_UNIT_TEST(Required) {
        const i64 Id = 1;
        const NYT::TNode Title = NYT::TNode()("en_US", "Soul");
        const NYT::TNode Hierarchy = NYT::TNode()("en_US", NYT::TNode().Add("Taxonomy XXX").Add("Auto").Add("Kia"));
        const i64 Tariff = 4;
        const NYT::TNode Description = NYT::TNode::CreateEntity();
        const NYT::TNode Acl = NYT::TNode::CreateEntity();
        const TSegment segment(Id, Title, Hierarchy, Tariff, Description, Acl, NSegmentStatuses::ENABLED, TIMESTAMP);
        const NYT::TNode raw = NYT::TNode()
            (NSegmentFields::ID, Id)
            (NSegmentFields::TITLE, Title)
            (NSegmentFields::HIERARCHY, Hierarchy)
            (NSegmentFields::TARIFF, Tariff);
       UNIT_ASSERT_EQUAL(ParseRawSegment(raw, TIMESTAMP), segment);
    }
}
