#include "raw_segment_validator.h"

#include <crypta/dmp/common/data/segment_fields.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/yson/node/node_io.h>
#include <util/stream/file.h>

using namespace NCrypta::NDmp;

Y_UNIT_TEST_SUITE(RawSegmentValidator) {
    Y_UNIT_TEST(Valid) {
        TFileInput in(ArcadiaSourceRoot() + "/crypta/dmp/yandex/bin/parse_segments/lib/test/data/raw_segment_validator_ut_valid.yson");
        const auto segments = NYT::NodeFromYsonString(in.ReadAll(), ::NYson::EYsonType::ListFragment).AsList();
        for (const auto& segment : segments) {
            const auto errors = ValidateRawSegment(segment);
            UNIT_ASSERT(errors.Empty());
        }
    }

    Y_UNIT_TEST(Invalid) {
        TFileInput in(ArcadiaSourceRoot() + "/crypta/dmp/yandex/bin/parse_segments/lib/test/data/raw_segment_validator_ut_invalid.yson");
        const auto tests = NYT::NodeFromYsonString(in.ReadAll(), ::NYson::EYsonType::ListFragment).AsList();
        for (const auto& test : tests) {
            const auto errors = ValidateRawSegment(test["in"]);
            UNIT_ASSERT_EQUAL(errors, test["out"]);
        }
    }
}
