#include <crypta/dmp/yandex/bin/common/config_fields.h>
#include <crypta/dmp/yandex/bin/prepare_bindings_to_upload/lib/prepare_bindings_to_upload_job.h>
#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>
#include <mapreduce/yt/interface/client.h>

using namespace NCrypta;
using namespace NDmp;

namespace {
    TPrepareBindingsToUploadJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TPrepareBindingsToUploadJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();
        config.DmpId = yaml[DMP_ID].as<ui64>();
        config.YandexuidBindingsTable = yaml[YANDEXUID_BINDINGS_TABLE].as<NYT::TYPath>();
        config.BbUploadStateTable = yaml[BB_UPLOAD_STATE_TABLE].as<NYT::TYPath>();
        config.ToBbProtoDir = yaml[BB_COLLECTOR_FRESH_DIR].as<NYT::TYPath>();
        config.UploadTtl = yaml[BB_UPLOAD_TTL].as<time_t>();
        config.BbUploadEnabled = yaml[BB_UPLOAD_ENABLED].as<bool>();

        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TPrepareBindingsToUploadJob, ParseConfig>(argc, argv);
}
