#pragma once

#include <crypta/lib/native/log/log.h>

#include <mapreduce/yt/interface/client.h>


namespace NCrypta::NDmp {
    class TPrepareBindingsToUploadJob {
    public:
        struct TConfig {
            TString YtProxy;
            TString YtPool;
            ui64 DmpId = 0;
            NYT::TYPath YandexuidBindingsTable;
            NYT::TYPath BbUploadStateTable;
            NYT::TYPath ToBbProtoDir;
            time_t UploadTtl = 0;
            bool BbUploadEnabled = false;
        };

        explicit TPrepareBindingsToUploadJob(const TConfig& config, NLog::TLogPtr log);

        int Do();

    private:
        const TConfig Config;
        NLog::TLogPtr Log;
    };
}
