#pragma once

#include <crypta/dmp/common/data/bb_upload_state.h>
#include <crypta/dmp/common/data/bindings.h>
#include <crypta/lib/native/time/ttl.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>

namespace NCrypta::NDmp {
    class TPrepareBindingsToUploadReducer : public NYT::IReducer<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        enum class EInputTables {
            YandexuidBindings,
            BbUploadState
        };

        enum class EOutputTables {
            BbUploadState,
            ToCollector,
        };

        using TInputIndexes = TTablesIndexes<EInputTables>;
        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TPrepareBindingsToUploadReducer() = default;
        TPrepareBindingsToUploadReducer(const TInputIndexes& inputIndexes,
                                        const TOutputIndexes& outputIndexes,
                                        ui64 uploadTimestamp,
                                        ui64 dmpId,
                                        time_t uploadTtl);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(InputIndexes, OutputIndexes, UploadTimestamp, DmpId, UploadTtl);

    private:
        std::pair<TMaybe<TBindings>, TMaybe<TBbUploadState>> ReadInput(TReader* reader) const;
        bool NeedToUpload(const TBindings& bindings, const TMaybe<TBbUploadState>& bbUploadState) const;
        void WriteToCollector(TWriter* writer, const TBindings& bindings) const;
        void WriteBbUploadState(TWriter* writer, const TBbUploadState& bbUploadState) const;

        TInputIndexes InputIndexes;
        TOutputIndexes OutputIndexes;
        ui64 UploadTimestamp = 0;
        ui64 DmpId = 0;
        TTtl UploadTtl;
    };
}
