import argparse
import logging

import yt.wrapper as yt

from crypta.dmp.common import index_status
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Publish index to YT")
    parser.add_argument("--config", required=True, type=yaml_config.load)
    parser.add_argument("--index", required=True, type=yaml_config.load)
    return parser.parse_args()


def get_index(index, env):
    return index if env == "testing" else [dmp for dmp in index if dmp["status"] == index_status.ACTIVE]


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()

    yt.config.set_proxy(args.config["yt-proxy"])
    index_table = args.config["index-table"]

    logger.info("Publish index to %s", index_table)

    with yt.Transaction():
        yt.mkdir(yt.ypath_dirname(index_table), recursive=True)
        yt.write_table(index_table, get_index(args.index, args.config["environment"]), force_create=True)

    logger.info("Done")
