import logging

import yt.wrapper as yt

from crypta.dmp.yandex.bin.send_quarantine_mail.lib import message_generator
from crypta.lib.python.yt import yt_helpers


logger = logging.getLogger(__name__)


def process(mail_sender, yt_client, quarantine_dir, processed_quarantine_dir, errors_amount, quarantine_ttl, dmp_login):
    for archive_name in yt_client.list(quarantine_dir, absolute=False):
        logger.info("Process %s", archive_name)
        archive_dir = yt.ypath_join(quarantine_dir, archive_name)
        processed_archive_dir = yt.ypath_join(processed_quarantine_dir, archive_name)

        errors_table = yt.TablePath(yt.ypath_join(archive_dir, "errors"), start_index=0, end_index=errors_amount)
        errors = yt_client.read_table(errors_table)

        subject = message_generator.get_subject(archive_name, dmp_login)
        body = message_generator.get_body(archive_name, errors)

        with yt_client.Transaction():
            yt_client.move(archive_dir, processed_archive_dir, recursive=True, force=True)
            mail_sender.send(subject, body)

        yt_helpers.set_ttl(processed_archive_dir, quarantine_ttl, yt_client=yt_client)
